#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_ReferenceData : BaseTest 
	{
		
		private DataTable _dtUnitStatus;
		private DataTable _dtAntibodyScreenDisplay;
		private DataTable _dtBloodType;
		private DataTable _dtTransfusionRequirementCategory;
		private DataTable _dtAntibodyType;
		private DataTable _dtAntigenType;
		private DataTable _dtComponentClass;
		private DataTable _dtProductModification;
		private DataTable _dtState;
		private DataTable _dtTestingMethod;
		private DataTable _dtTestResult;
		private DataTable _dtTransfusionReactionType;
		private DataTable _dtUserRole;
		private DataTable _dtTimeZone;
		private DataTable _dtTaskStatus;
		private DataTable _dtSpecimenStatus;
		private DataTable _dtLockFunction;
		private DataTable _dtOrderableTest;
		private DataTable _dtProductType;
		private DataTable _dtReactivityPhase;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtUnitStatus = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM UnitStatus", true);

				//*********AntibodyScreenDisplay 
				this._dtAntibodyScreenDisplay = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM AntibodyScreenDisplay", true);

				//*********BloodType 
				this._dtBloodType = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM BloodType", true);
				
				//*********TransfustionRequirementCategory 
				this._dtTransfusionRequirementCategory = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM TransfusionRequirementCategory", true);

				//*********AntibodyType 
				this._dtAntibodyType = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM AntibodyType JOIN AntibodyAntigen ON AntibodyAntigen.AntibodyTypeId = AntibodyType.AntibodyTypeId	JOIN AntigenType ON AntibodyAntigen.AntigenTypeId = AntigenType.AntigenTypeId", true);

				//*********AntigenType 
				this._dtAntigenType = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM AntigenType", true);

				//*********ComponentClass
				this._dtComponentClass = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM ComponentClass", true);

				//***********LockFunction
				this._dtLockFunction = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM VbecsLockFunction", true);

				//*********ProductModification
				this._dtProductModification = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM ProductModification", true);
				
				//*********OrderableTest
				this._dtOrderableTest = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM OrderableTest", true);

				//*********State
				this._dtState = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM State", true);

				//*********TaskStatus
				this._dtTaskStatus = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM TaskStatus", true);

				//*********SpecimenStatus
				this._dtSpecimenStatus = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM SpecimenStatus", true);

				//*********TestingMethod
				this._dtTestingMethod = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM TestingMethod", true);

				//*********TestResult
				this._dtTestResult = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM TestResult", true);

				//*********TransfusionReactionType
				this._dtTransfusionReactionType = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM TransfusionReactionType", true);

				//*********UserRole
				this._dtUserRole = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM UserRole", true);

				//*********ProductType
				this._dtProductType = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM ProductType", true);

				//*********TimeZone
				this._dtTimeZone = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM TimeZone", true);

				//*********ReactivityPhase
				this._dtReactivityPhase = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM ReactivityPhase", true);
				this.RefreshData = false;
			}
		}

		//TODO: Remove blank constructor in DAL.ReferenceData - not needed
		
		//NOTE: Code coverage cannot be guaranteed to be 100% every time, because some "GetxxxList()" methods are 
		//      executed before their "Getxxx()" counterpart - causing the first if condition in "Getxxx()" to aways always fail

		[Test]
		public void GetUnitStatus_Pass()
		{
			string unitCode = this._dtUnitStatus.Rows[0][TABLES.UnitStatus.UnitStatusCode].ToString();

			DataRow drCheck = DAL.ReferenceData.GetUnitStatus(unitCode);

			Assert.AreEqual(5, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.UnitStatus.UnitStatusCode), TABLES.UnitStatus.UnitStatusCode);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.UnitStatus.SortColumn), TABLES.UnitStatus.SortColumn);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.UnitStatus.LastUpdateUser), TABLES.UnitStatus.LastUpdateUser);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.UnitStatus.RowVersion), TABLES.UnitStatus.RowVersion);
		}

		[Test]
        [ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetUnitStatus_Fail()
		{
			DAL.ReferenceData.GetUnitStatus(string.Empty);
		}

		[Test]
		public void GetUnitStatusList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetUnitStatusList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtUnitStatus.Rows.Count, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusCode), TABLES.UnitStatus.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.SortColumn), TABLES.UnitStatus.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.LastUpdateUser), TABLES.UnitStatus.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.RowVersion), TABLES.UnitStatus.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetUnitStatusList_Fail()
		{
		}

		[Test]
		public void GetAntibodyScreenDisplay_Pass()
		{
			int unitId = System.Convert.ToInt16(this._dtAntibodyScreenDisplay.Rows[0][TABLES.AntibodyScreenDisplay.AntibodyScreenDisplayCode]);

			DataRow drCheck = DAL.ReferenceData.GetAntibodyScreenDisplay(unitId);

			Assert.AreEqual(5, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.AntibodyScreenDisplay.AntibodyScreenDisplayCode), TABLES.AntibodyScreenDisplay.AntibodyScreenDisplayCode);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.AntibodyScreenDisplay.AntibodyScreenDisplayText), TABLES.AntibodyScreenDisplay.AntibodyScreenDisplayText);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.AntibodyScreenDisplay.SortColumn), TABLES.AntibodyScreenDisplay.SortColumn);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.AntibodyScreenDisplay.LastUpdateUser), TABLES.AntibodyScreenDisplay.LastUpdateUser);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.AntibodyScreenDisplay.RowVersion), TABLES.AntibodyScreenDisplay.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetAntibodyScreenDisplay_Fail()
		{
			DAL.ReferenceData.GetAntibodyScreenDisplay(int.MinValue);
		}

		[Test]
		public void GetAntibodyScreenDisplayList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetAntibodyScreenDisplayList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtAntibodyScreenDisplay.Rows.Count, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyScreenDisplay.AntibodyScreenDisplayCode), TABLES.AntibodyScreenDisplay.AntibodyScreenDisplayCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyScreenDisplay.AntibodyScreenDisplayText), TABLES.AntibodyScreenDisplay.AntibodyScreenDisplayText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyScreenDisplay.SortColumn), TABLES.AntibodyScreenDisplay.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyScreenDisplay.LastUpdateUser), TABLES.AntibodyScreenDisplay.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyScreenDisplay.RowVersion), TABLES.AntibodyScreenDisplay.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntibodyScreenDisplayList_Fail()
		{
		}

		[Test]
		public void GetBloodType_Pass()
		{
			string unitCode = this._dtBloodType.Rows[0][TABLES.BloodType.BloodTypeCode].ToString();

			DataRow drCheck = DAL.ReferenceData.GetBloodType(unitCode);

			Assert.AreEqual(6, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.BloodType.BloodTypeCode), TABLES.BloodType.BloodTypeCode);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.BloodType.BloodTypeText), TABLES.BloodType.BloodTypeText);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.BloodType.SortColumn), TABLES.BloodType.SortColumn);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.BloodType.LastUpdateUser), TABLES.BloodType.LastUpdateUser);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.BloodType.LastUpdateDate), TABLES.BloodType.LastUpdateDate);
			
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.BloodType.RowVersion), TABLES.BloodType.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetBloodType_Fail()
		{
			DAL.ReferenceData.GetBloodType(string.Empty);
		}

		[Test]
		public void GetBloodTypeList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetBloodTypeList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtBloodType.Rows.Count, "Rows.Count");
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodType.BloodTypeCode), TABLES.BloodType.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodType.BloodTypeText), TABLES.BloodType.BloodTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodType.SortColumn), TABLES.BloodType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodType.LastUpdateUser), TABLES.BloodType.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodType.LastUpdateDate), TABLES.BloodType.LastUpdateDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodType.RowVersion), TABLES.BloodType.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBloodTypeList_Fail()
		{
		}

		[Test]
		public void GetTransfusionRequirementCategory_Pass()
		{
			string unitCode = this._dtTransfusionRequirementCategory.Rows[0][TABLES.TransfusionRequirementCategory.TransfusionRequirementCategoryCode].ToString();

			DataRow drCheck = DAL.ReferenceData.GetTransfusionRequirementCategory(unitCode);

			Assert.AreEqual(5, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TransfusionRequirementCategory.TransfusionRequirementCategoryCode), TABLES.TransfusionRequirementCategory.TransfusionRequirementCategoryCode);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TransfusionRequirementCategory.TransfusionRequirementCategoryText), TABLES.TransfusionRequirementCategory.TransfusionRequirementCategoryText);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TransfusionRequirementCategory.SortColumn), TABLES.TransfusionRequirementCategory.SortColumn);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TransfusionRequirementCategory.LastUpdateUser), TABLES.TransfusionRequirementCategory.LastUpdateUser);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TransfusionRequirementCategory.RowVersion), TABLES.TransfusionRequirementCategory.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetTransfusionRequirementCategory_Fail()
		{
			DAL.ReferenceData.GetTransfusionRequirementCategory(string.Empty);
		}

		[Test]
		public void GetTransfusionRequirementCategoryList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetTransfusionRequirementCategoryList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtTransfusionRequirementCategory.Rows.Count, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionRequirementCategory.TransfusionRequirementCategoryCode), TABLES.TransfusionRequirementCategory.TransfusionRequirementCategoryCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionRequirementCategory.TransfusionRequirementCategoryText), TABLES.TransfusionRequirementCategory.TransfusionRequirementCategoryText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionRequirementCategory.SortColumn), TABLES.TransfusionRequirementCategory.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionRequirementCategory.LastUpdateUser), TABLES.TransfusionRequirementCategory.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionRequirementCategory.RowVersion), TABLES.TransfusionRequirementCategory.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTransfusionRequirementCategoryList_Fail()
		{
		}

		[Test]
		public void GetAntibodyTypeList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetAntibodyTypeList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtAntibodyType.Rows.Count, "Rows.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeId), TABLES.AntibodyType.AntibodyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.AntigenTypeId), TABLES.AntigenType.AntigenTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeName), TABLES.AntibodyType.AntibodyTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.AntigenTypeName), TABLES.AntigenType.AntigenTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyReferenceCode), TABLES.AntibodyType.AntibodyReferenceCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.SortColumn), TABLES.AntibodyType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.LastUpdateUser), TABLES.AntibodyType.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.RowVersion), TABLES.AntibodyType.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntibodyTypeList_Fail()
		{
		}

		[Test]
		public void GetAntigenType_Pass()
		{
			int unitId = System.Convert.ToInt16(this._dtAntigenType.Rows[0][TABLES.AntigenType.AntigenTypeId]);

			DataRow drCheck = DAL.ReferenceData.GetAntigenType(unitId);

			Assert.AreEqual(5, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.AntigenType.AntigenTypeId), TABLES.AntigenType.AntigenTypeId);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.AntigenType.AntigenTypeName), TABLES.AntigenType.AntigenTypeName);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.AntigenType.SortColumn), TABLES.AntigenType.SortColumn);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.AntigenType.LastUpdateUser), TABLES.AntigenType.LastUpdateUser);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.AntigenType.RowVersion), TABLES.AntigenType.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetAntigenType_Fail()
		{
			DAL.ReferenceData.GetAntigenType(int.MinValue);
		}

		[Test]
		public void GetAntigenTypeList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetAntigenTypeList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtAntigenType.Rows.Count, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.AntigenTypeId), TABLES.AntigenType.AntigenTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.AntigenTypeName), TABLES.AntigenType.AntigenTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.SortColumn), TABLES.AntigenType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.LastUpdateUser), TABLES.AntigenType.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.RowVersion), TABLES.AntigenType.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntigenTypeList_Fail()
		{
		}

		[Test]
		public void GetComponentClass_Pass()
		{
			int unitId = System.Convert.ToInt16(this._dtComponentClass.Rows[0][TABLES.ComponentClass.ComponentClassId]);

			DataRow drCheck = DAL.ReferenceData.GetComponentClass(unitId);

			Assert.AreEqual(8, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.ComponentClass.ComponentClassShortName), TABLES.ComponentClass.ComponentClassShortName);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.ComponentClass.CprsOrderableItemId), TABLES.ComponentClass.CprsOrderableItemId);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.ComponentClass.SortColumn), TABLES.ComponentClass.SortColumn);
			
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.ComponentClass.LastUpdateDate), TABLES.ComponentClass.LastUpdateDate);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.ComponentClass.LastUpdateUser), TABLES.ComponentClass.LastUpdateUser);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.ComponentClass.RowVersion), TABLES.ComponentClass.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetComponentClass_Fail()
		{
			DAL.ReferenceData.GetComponentClass(int.MinValue);
		}

		[Test]
		public void GetComponentClassList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetComponentClassList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtComponentClass.Rows.Count, "Rows.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassShortName), TABLES.ComponentClass.ComponentClassShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.CprsOrderableItemId), TABLES.ComponentClass.CprsOrderableItemId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.SortColumn), TABLES.ComponentClass.SortColumn);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.LastUpdateDate), TABLES.ComponentClass.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.LastUpdateUser), TABLES.ComponentClass.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.RowVersion), TABLES.ComponentClass.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetComponentClassList_Fail()
		{
		}

		[Test]
		public void GetLockFunction_Pass()
		{
			DataRow drCheck = DAL.ReferenceData.GetLockFunction(Common.LockFunctions.UnitTests);

			Assert.AreEqual(6, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.VbecsLockFunction.VbecsFunctionId), TABLES.VbecsLockFunction.VbecsFunctionId);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.VbecsLockFunction.FunctionName), TABLES.VbecsLockFunction.FunctionName);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.VbecsLockFunction.FunctionDescription), TABLES.VbecsLockFunction.FunctionDescription);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.VbecsLockFunction.LastUpdateDate), TABLES.VbecsLockFunction.LastUpdateDate);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.VbecsLockFunction.LastUpdateUser), TABLES.VbecsLockFunction.LastUpdateUser);
			
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.VbecsLockFunction.RowVersion), TABLES.VbecsLockFunction.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetLockFunction_Fail()
		{
			//The failure condition (where record count returned != 1) cannot be tested since enum code matches the database
		}


		[Test]
		public void GetLockFunctionList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetLockFunctionList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtLockFunction.Rows.Count, "Rows.Count");
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLockFunction.VbecsFunctionId), TABLES.VbecsLockFunction.VbecsFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLockFunction.FunctionName), TABLES.VbecsLockFunction.FunctionName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLockFunction.FunctionDescription), TABLES.VbecsLockFunction.FunctionDescription);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLockFunction.LastUpdateDate), TABLES.VbecsLockFunction.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLockFunction.LastUpdateUser), TABLES.VbecsLockFunction.LastUpdateUser);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLockFunction.RowVersion), TABLES.VbecsLockFunction.RowVersion);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetLockFunctionList_Fail()
		{
		}

		[Test]
		public void GetTaskStatus_Pass()
		{
			string unitCode = this._dtTaskStatus.Rows[0][TABLES.TaskStatus.TaskStatusCode].ToString();

			DataRow drCheck = DAL.ReferenceData.GetTaskStatus(unitCode);

			Assert.AreEqual(5, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TaskStatus.TaskStatusCode), TABLES.TaskStatus.TaskStatusCode);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TaskStatus.TaskStatusText), TABLES.TaskStatus.TaskStatusText);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TaskStatus.SortColumn), TABLES.TaskStatus.SortColumn);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TaskStatus.LastUpdateUser), TABLES.TaskStatus.LastUpdateUser);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TaskStatus.RowVersion), TABLES.TaskStatus.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetTaskStatus_Fail()
		{
			DAL.ReferenceData.GetTaskStatus(string.Empty);
		}

		[Test]
		public void GetTaskStatusList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetTaskStatusList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtTaskStatus.Rows.Count, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TaskStatus.TaskStatusCode), TABLES.TaskStatus.TaskStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TaskStatus.TaskStatusText), TABLES.TaskStatus.TaskStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TaskStatus.SortColumn), TABLES.TaskStatus.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TaskStatus.LastUpdateUser), TABLES.TaskStatus.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TaskStatus.RowVersion), TABLES.TaskStatus.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTaskStatusList_Fail()
		{
		}


		[Test]
		public void GetSpecimenStatus_Pass()
		{
			string unitCode = this._dtSpecimenStatus.Rows[0][TABLES.SpecimenStatus.SpecimenStatusCode].ToString();

			DataRow drCheck = DAL.ReferenceData.GetSpecimenStatus(unitCode);

			Assert.AreEqual(5, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.SpecimenStatus.SpecimenStatusCode), TABLES.SpecimenStatus.SpecimenStatusCode);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.SpecimenStatus.SpecimenStatusText), TABLES.SpecimenStatus.SpecimenStatusText);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.SpecimenStatus.SortColumn), TABLES.SpecimenStatus.SortColumn);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.SpecimenStatus.LastUpdateUser), TABLES.SpecimenStatus.LastUpdateUser);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.SpecimenStatus.RowVersion), TABLES.SpecimenStatus.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetSpecimenStatus_Fail()
		{
			DAL.ReferenceData.GetSpecimenStatus(string.Empty);
		}

		[Test]
		public void GetSpecimenStatusList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetSpecimenStatusList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtSpecimenStatus.Rows.Count, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenStatus.SpecimenStatusCode), TABLES.SpecimenStatus.SpecimenStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenStatus.SpecimenStatusText), TABLES.SpecimenStatus.SpecimenStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenStatus.SortColumn), TABLES.SpecimenStatus.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenStatus.LastUpdateUser), TABLES.SpecimenStatus.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenStatus.RowVersion), TABLES.SpecimenStatus.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetSpecimenStatusList_Fail()
		{
		}

		[Test]
		public void GetProductModification_Pass()
		{
			string unitCode = this._dtProductModification.Rows[0][TABLES.ProductModification.ProductModificationCode].ToString();

			DataRow drCheck = DAL.ReferenceData.GetProductModification(unitCode);

			Assert.AreEqual(5, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.ProductModification.ProductModificationCode), TABLES.ProductModification.ProductModificationCode);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.ProductModification.ProductModificationText), TABLES.ProductModification.ProductModificationText);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.ProductModification.SortColumn), TABLES.ProductModification.SortColumn);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.ProductModification.LastUpdateUser), TABLES.ProductModification.LastUpdateUser);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.ProductModification.RowVersion), TABLES.ProductModification.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetProductModification_Fail()
		{
			DAL.ReferenceData.GetProductModification(string.Empty);
		}

		[Test]
		public void GetProductModificationList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetProductModificationList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtProductModification.Rows.Count, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductModification.ProductModificationCode), TABLES.ProductModification.ProductModificationCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductModification.ProductModificationText), TABLES.ProductModification.ProductModificationText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductModification.SortColumn), TABLES.ProductModification.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductModification.LastUpdateUser), TABLES.ProductModification.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductModification.RowVersion), TABLES.ProductModification.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetProductModificationList_Fail()
		{
		}

		[Test]
		public void GetState_Pass()
		{
			string unitCode = this._dtState.Rows[0][TABLES.State.StateCode].ToString();

			DataRow drCheck = DAL.ReferenceData.GetState(unitCode);

			Assert.AreEqual(4, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.State.StateCode), TABLES.State.StateCode);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.State.StateName), TABLES.State.StateName);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.State.LastUpdateUser), TABLES.State.LastUpdateUser);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.State.RowVersion), TABLES.State.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetState_Fail()
		{
			DAL.ReferenceData.GetState(string.Empty);
		}

		[Test]
		public void GetStateList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetStateList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtState.Rows.Count, "Rows.Count");
			Assert.AreEqual(4, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.State.StateCode), TABLES.State.StateCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.State.StateName), TABLES.State.StateName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.State.LastUpdateUser), TABLES.State.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.State.RowVersion), TABLES.State.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetStateList_Fail()
		{
		}

		[Test]
		public void GetTestingMethod_Pass()
		{
			string unitCode = this._dtTestingMethod.Rows[0][TABLES.TestingMethod.TestingMethodCode].ToString();

			DataRow drCheck = DAL.ReferenceData.GetTestingMethod(unitCode);

			Assert.AreEqual(6, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TestingMethod.TestingMethodCode), TABLES.TestingMethod.TestingMethodCode);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TestingMethod.TestingMethodText), TABLES.TestingMethod.TestingMethodText);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TestingMethod.SortColumn), TABLES.TestingMethod.SortColumn);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TestingMethod.LastUpdateDate), TABLES.TestingMethod.LastUpdateDate);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TestingMethod.LastUpdateUser), TABLES.TestingMethod.LastUpdateUser);

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TestingMethod.RowVersion), TABLES.TestingMethod.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetTestingMethod_Fail()
		{
			DAL.ReferenceData.GetTestingMethod(string.Empty);
		}

		[Test]
		public void GetTestingMethodList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetTestingMethodList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtTestingMethod.Rows.Count, "Rows.Count");
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.TestingMethodCode), TABLES.TestingMethod.TestingMethodText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.TestingMethodText), TABLES.TestingMethod.TestingMethodText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.SortColumn), TABLES.TestingMethod.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.LastUpdateDate), TABLES.TestingMethod.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.LastUpdateUser), TABLES.TestingMethod.LastUpdateUser);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.RowVersion) , TABLES.TestingMethod.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestingMethodList_Fail()
		{
		}

		[Test]
		public void GetTestResultList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetTestResultList();

			
			Assert.AreEqual(dtTest.Rows.Count, this._dtTestResult.Rows.Count, "Rows.Count");
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultId), TABLES.TestResult.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.CanChangeIndicator), TABLES.TestResult.CanChangeIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.SortColumn), TABLES.TestResult.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.LastUpdateUser), TABLES.TestResult.LastUpdateUser);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.RowVersion), TABLES.TestResult.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestResultList_Fail()
		{
		}

		[Test]
		public void GetTransfusionReactionType_Pass()
		{
			char unitCode = Convert.ToChar(this._dtTransfusionReactionType.Rows[0][TABLES.TransfusionReactionType.TransfusionReactionTypeCode]);

			DataRow drCheck = DAL.ReferenceData.GetTransfusionReactionType(unitCode);

			Assert.AreEqual(6, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeCode), TABLES.TransfusionReactionType.TransfusionReactionTypeCode);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeText), TABLES.TransfusionReactionType.TransfusionReactionTypeText);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TransfusionReactionType.SortColumn), TABLES.TransfusionReactionType.SortColumn);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TransfusionReactionType.LastUpdateUser), TABLES.TransfusionReactionType.LastUpdateUser);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TransfusionReactionType.LastUpdateDate), TABLES.TransfusionReactionType.LastUpdateDate);

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TransfusionReactionType.RowVersion), TABLES.TransfusionReactionType.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetTransfusionReactionType_Fail()
		{
			DAL.ReferenceData.GetTransfusionReactionType(char.MinValue);
		}

		[Test]
		public void GetTransfusionReactionTypeList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetTransfusionReactionTypeList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtTransfusionReactionType.Rows.Count, "Rows.Count");
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeCode), TABLES.TransfusionReactionType.TransfusionReactionTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeText), TABLES.TransfusionReactionType.TransfusionReactionTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.SortColumn), TABLES.TransfusionReactionType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.LastUpdateDate), TABLES.TransfusionReactionType.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.LastUpdateUser), TABLES.TransfusionReactionType.LastUpdateUser);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.RowVersion), TABLES.TransfusionReactionType.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTransfusionReactionTypeList_Fail()
		{
		}

		[Test]
		public void GetUserRole_Pass()
		{
			int unitId = System.Convert.ToInt16(this._dtUserRole.Rows[0][TABLES.UserRole.UserRoleId]);

			DataRow drCheck = DAL.ReferenceData.GetUserRole(unitId);

			Assert.AreEqual(5, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.UserRole.UserRoleId), TABLES.UserRole.UserRoleId);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.UserRole.UserRoleName), TABLES.UserRole.UserRoleName);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.UserRole.SortColumn), TABLES.UserRole.SortColumn);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.UserRole.LastUpdateUser), TABLES.UserRole.LastUpdateUser);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.UserRole.RowVersion), TABLES.UserRole.LastUpdateUser);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetUserRole_Fail()
		{
			DAL.ReferenceData.GetUserRole(int.MinValue);
		}

		[Test]
		public void GetUserRoleList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetUserRoleList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtUserRole.Rows.Count, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UserRole.UserRoleId), TABLES.UserRole.UserRoleId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UserRole.UserRoleName), TABLES.UserRole.UserRoleId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UserRole.SortColumn), TABLES.UserRole.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UserRole.LastUpdateUser), TABLES.UserRole.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UserRole.RowVersion), TABLES.UserRole.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetUserRoleList_Fail()
		{
		}

		[Test]
		public void GetTimeZone_Pass()
		{
			string unitCode = this._dtTimeZone.Rows[0][TABLES.TimeZone.TimeZoneId].ToString();

			DataRow drCheck = DAL.ReferenceData.GetTimeZone(unitCode);

			Assert.AreEqual(3, drCheck.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TimeZone.TimeZoneId), TABLES.TimeZone.TimeZoneId);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TimeZone.TimeZoneName), TABLES.TimeZone.TimeZoneName);
			Assert.AreEqual(true, drCheck.Table.Columns.Contains(TABLES.TimeZone.StandardTimeText), TABLES.TimeZone.StandardTimeText);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetTimeZone_Fail()
		{
			DAL.ReferenceData.GetTimeZone(string.Empty);
		}

		[Test]
		public void GetTimeZoneList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetTimeZoneList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtTimeZone.Rows.Count , "Rows.Count");
			Assert.AreEqual(dtTest.Columns.Count, 3, dtTest.Columns.Count);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TimeZone.TimeZoneId), TABLES.TimeZone.TimeZoneId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TimeZone.TimeZoneName), TABLES.TimeZone.TimeZoneName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TimeZone.StandardTimeText), TABLES.TimeZone.StandardTimeText);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTimeZoneList_Fail()
		{
		}


		[Test]
		public void GetOrderableTestList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetOrderableTestList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtOrderableTest.Rows.Count , "Rows.Count");
			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestId), TABLES.OrderableTest.OrderableTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestName), TABLES.OrderableTest.OrderableTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestText), TABLES.OrderableTest.OrderableTestText);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderableTestList_Fail()
		{
		}

		[Test]
		public void GetOrderableTest_Pass()
		{
			int testId = System.Convert.ToInt16(this._dtOrderableTest.Rows[0][TABLES.OrderableTest.OrderableTestId]);

			DataRow drTest = DAL.ReferenceData.GetOrderableTest(testId);

			Assert.AreEqual(3, drTest.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.OrderableTest.OrderableTestId), TABLES.OrderableTest.OrderableTestId);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.OrderableTest.OrderableTestName), TABLES.OrderableTest.OrderableTestName);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.OrderableTest.OrderableTestText), TABLES.OrderableTest.OrderableTestText);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetOrderableTest_Fail()
		{
			DAL.ReferenceData.GetOrderableTest(int.MinValue);
		}

		[Test]
		public void GetReactivityPhaseList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetReactivityPhaseList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtReactivityPhase.Rows.Count, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseCode), TABLES.ReactivityPhase.ReactivityPhaseCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseText), TABLES.ReactivityPhase.ReactivityPhaseText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.SortColumn), TABLES.ReactivityPhase.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.LastUpdateUser), TABLES.ReactivityPhase.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.RowVersion), TABLES.ReactivityPhase.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReactivityPhaseList_Fail()
		{
		}


		[Test]
		public void GetReactivityPhase_Pass()
		{
			int phaseCode = System.Convert.ToInt16(this._dtReactivityPhase.Rows[0][TABLES.ReactivityPhase.ReactivityPhaseCode]);

			DataRow drTest = DAL.ReferenceData.GetReactivityPhase(phaseCode);

			Assert.AreEqual(5, drTest.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseCode), TABLES.ReactivityPhase.ReactivityPhaseCode);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseText), TABLES.ReactivityPhase.ReactivityPhaseText);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.ReactivityPhase.SortColumn), TABLES.ReactivityPhase.SortColumn);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.ReactivityPhase.LastUpdateUser), TABLES.ReactivityPhase.LastUpdateUser);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.ReactivityPhase.RowVersion), TABLES.ReactivityPhase.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetReactivityPhase_Fail()
		{
			DAL.ReferenceData.GetReactivityPhase(int.MinValue);
		}


		[Test]
		public void GetProductTypeList_Pass()
		{
			DataTable dtTest = DAL.ReferenceData.GetProductTypeList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtProductType.Rows.Count, "Rows.Count");
			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeCode), TABLES.ProductType.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetProductTypeList_Fail()
		{
		}

		[Test]
		public void GetProductType_Pass()
		{
			string typeCode = this._dtProductType.Rows[0][TABLES.ProductType.ProductTypeCode].ToString();

			DataRow drTest = DAL.ReferenceData.GetProductType(typeCode);

			Assert.AreEqual(2, drTest.Table.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.ProductType.ProductTypeCode), TABLES.ProductType.ProductTypeCode);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetProductType_Fail()
		{
			DAL.ReferenceData.GetProductType("MITTENS");
		}

	}
}
#endif
